<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/


class CNewsWidgetArticleList extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "1",
		"name"	=> "Article List",
	);

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {
		$cnt = max(1, $widget["settings"]["set_items"]);


		switch ($widget["settings"]["set_type"]) {
			//latest
			default:
				$order = "item_date DESC";
			break;

			//most viewed
			case "2":
				$order = "item_set_views DESC , item_date DESC";
			break;
		}


		$items = $this->db->QFetchRowArray(
			"SELECT * FROM {$this->tables['plugin:news_items']} as t , {$this->tables['plugin:news_items_lang']} as l 
			WHERE t.module_id = {$widget[mod_id]} AND l.lang_id={$widget[lang_id]} AND t.item_id=l.item_id 
			ORDER BY {$order}
			LIMIT $cnt
			"
		);

		if (is_array($items)) {

			global $base;


			$elements = explode("," , $widget["settings"]["set_elements"]);

			foreach ($items as $key => $val) {
				$val["link"] = $items[$key]["link"] = $widget["link"] .$val["item_url"] . "/" . $val["item_id"];

				$this->module->ProcessElements($items[$key], $elements , $this->tpl , "listing" , $widget["mod_settings"]);

				//overwrite image setting
				if (in_array("image" , $elements)) {
					$val["image"] = $this->plugins["media"]->GetThumb($val["item_id"] , $val["module_id"] , array("path" => "upload/news"));
					$items[$key]["_image"] = $this->tpl->blockReplace($val["image"] ? "Photo" : "NoPhoto" , $val);
				} 

				$items[$key]["item_brief"] = substr(strip_tags($val["item_brief"]) , 0, $widget["settings"]["set_chars"]) . "[...]";
			}
			

			return $this->tpl->blockReplace(
				"Main" , 
				array(
					"news"	=> $base->html->table(
						$this->tpl , 
						"" , 
						$items
					)
				),
				$widget,
				$widget["settings"],
				$widget["mod_settings"]
			);
		}

	}
	
}


?>